<?php
namespace DogriElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Dogri Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Blog_Post_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Dogri Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'blog_post_widget';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Dogri Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Blog Post Widget', 'dogri-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Dogri Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-post-content';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Dogri Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'dogri-elementor' ];
	}

	public function get_keywords() {
		return [ 'blog-post' ];
	}

	public function get_script_depends() {
		return [ 'dogri-elementor'];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'Blog_Post_Widget',
			[
				'label' => esc_html__( 'Section Heading', 'dogri-elementor' ),
			]
		);

		$this->add_control(
			'sub_title',
			[
				'label'       => __( 'Sub Heading', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => __( 'It is sub heading', 'dogri-elementor' ),
				'placeholder' => __( 'Enter your subheading here...', 'dogri-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => __( 'Heading', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'default'     => __( 'It is heading', 'dogri-elementor' ),
				'placeholder' => __( 'Enter your heading here...', 'dogri-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'background_bg',
			[
				'label'   => esc_html__( 'Background Image', 'dogri-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add Your Background Image', 'dogri-elementor' ),
				// 'condition' => [
				// 	'chose_style' => ['counter-style-1']
				// ],
			]
		);

		// $this->add_control(
		// 	'bgimg',
		// 	[
		// 		'label' => esc_html__('Background image', 'dogri-elementor'),
		// 		'type' => Controls_Manager::MEDIA,
		// 		'default' => ['url' => Utils::get_placeholder_image_src(),],
		// 	]
		// );	

		$this->end_controls_section();


		$this->start_controls_section(
			'section_content_service_post',
			[
				'label' => esc_html__( 'Blog Post', 'dogri-elementor' ),
			]
		);

		$this->add_control(
			'chose_style',
			[
				'label'     => esc_html__( 'Chose Style', 'dogri-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'blog-style-1'  => esc_html__( 'Latest Blog Style 1', 'dogri-elementor' ),
					'blog-style-2' => esc_html__( 'Latest Blog Style 2', 'dogri-elementor' ),
				],
				'default'   => 'blog-style-1',
			]
		);

		$this->add_control(
			'heading_word_count',
			[
				'label'       => __( 'Heading Word Count', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Type Heading Words Number', 'dogri-elementor' ),
				'default'   => 7,				
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'     => esc_html__( 'Order By', 'dogri-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'ID'  => esc_html__( 'Post ID', 'dogri-elementor' ),
					'title'  => esc_html__( 'Title', 'dogri-elementor' ),
					'date' => esc_html__( 'Date', 'dogri-elementor' ),
					'modified' => esc_html__( 'Last Modified Date', 'dogri-elementor' ),
					'rand' => esc_html__( 'Random Order', 'dogri-elementor' ),
					'comment_count' => esc_html__( 'Popular Post', 'dogri-elementor' ),
				],
				'default'   => 'ID',
			]
		);

		$this->add_control(
			'order',
			[
				'label'     => esc_html__( 'Post Order', 'dogri-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'asc'  => esc_html__( 'ASC', 'dogri-elementor' ),
					'desc' => esc_html__( 'DESC', 'dogri-elementor' ),
				],
				'default'   => 'desc',
			]
		);		

		$this->add_control(
			'number',
			[
				'label'     => esc_html__( 'Post Count', 'dogri-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'1'  => esc_html__( '1', 'dogri-elementor' ),
					'2'  => esc_html__( '2', 'dogri-elementor' ),
					'3'  => esc_html__( '3', 'dogri-elementor' ),
					'4'  => esc_html__( '4', 'dogri-elementor' ),
					'5'  => esc_html__( '5', 'dogri-elementor' ),
					'6' => esc_html__( '6', 'dogri-elementor' ),
					'7' => esc_html__( '7', 'dogri-elementor' ),
					'8' => esc_html__( '8', 'dogri-elementor' ),
					'9' => esc_html__( '9', 'dogri-elementor' ),
					'10' => esc_html__( '10', 'dogri-elementor' ),
					'-1' => esc_html__( 'Show All', 'dogri-elementor' ),
				],
				'default'   => '3',
			]
		);

		$this->add_control(
			'cat',
			[
				'label'       => __( 'Category Slug', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter category slug here...', 'dogri-elementor' ),
				'label_block' => true,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'dogri-elementor' ),
			]
		);		

		$this->add_control(
			'show_heading_section',
			[
				'label'   => esc_html__( 'Show Heading Section', 'dogri-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_title',
			[
				'label'   => esc_html__( 'Show title', 'dogri-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => [
					'show_heading_section' => 'yes'
				],
			]
		);	

		$this->add_control(
			'show_sub_title',
			[
				'label'   => esc_html__( 'Show Sub Title', 'dogri-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => [
					'show_heading_section' => 'yes'
				],
			]
		);


		$this->add_control(
			'show_link',
			[
				'label'   => esc_html__( 'Show Link', 'dogri-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();


    //Background Color ==========================

    $this->start_controls_section(
        'bg_color_block_settings',
        array(
            'label' => __( 'Background Color Setting', 'dogri-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        )
    );			

    $this->add_control(
        'block_bg_color',
        array(
            'label'     => __( 'Section Background Color', 'dogri-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => array(
                '{{WRAPPER}} .news-section' => 'background: {{VALUE}} !important',
            ),
        )
    );

    $this->add_control(
        'block_bg_color_1',
        array(
            'label'     => __( 'Card Background Color', 'dogri-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => array(
                '{{WRAPPER}} .news-section .lower-content.text-centerd' => 'background: {{VALUE}} !important',
            ),
        )
    );

    $this->end_controls_section();

    //End of Background Color  


	        //Section Padding Block==========================
			$this->start_controls_section(
				'section_padding_settings',
				array(
					'label' => __( 'Section Padding Setting', 'dogri-elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				)
			);
			
			$this->add_control(
				'block_margin',
				array(
					'label'     => __( 'Block Margin', 'dogri-elementor' ),
					'type'      => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' =>  ['px', '%', 'em' ],
				
					'selectors' => array(
						'{{WRAPPER}} .news-section' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					),
				)
			);

			$this->add_control(
				'block_padding',
				array(
					'label'     => __( 'Block Padding', 'dogri-elementor' ),
					'type'      => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' =>  ['px', '%', 'em' ],
				
					'selectors' => array(
						'{{WRAPPER}} .news-section' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					),
				)
			);

			$this->end_controls_section();
			//End of Section Padding Block 

		//Section Sub Title	==================		

		$this->start_controls_section(
			'section_subtitle_settings',
			array(
				'label' => __( 'Section Sub Title Setting', 'dogri-elementor' ),
			
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'show_section_subtitle',
			array(
				'label' => esc_html__( 'Show Section Sub Title', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementor' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementor' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .news-section .title-box.text-center .sec-sub-title' => 'display: {{VALUE}} !important',
				),
			)
		);	

		$this->add_control(
			'section_subtitle_alignment',
			array(
				'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'toggle' => true,
				'selectors' => array(
				
					'{{WRAPPER}} .news-section .title-box.text-center' => 'text-align: {{VALUE}}',
					
				),
			)
		);

		$this->add_control(
			'section_subtitle_margin',
			array(
				'label'     => __( 'Margin', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
			'{{WRAPPER}} .news-section .title-box.text-center .sec-sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
				),
			)
		);

		$this->add_control(
			'section_subtitle_padding',
			array(
				'label'     => __( 'Padding', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
			'{{WRAPPER}} .news-section .title-box.text-center .sec-sub-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
				),
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),

			array(
				'name'     => 'section_subtitle_typography',
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementor' ),
				'selector' => '{{WRAPPER}} .news-section .title-box.text-center .sec-sub-title',
			)
		);


		$this->add_control(
			'section_subtitle_color',
			array(
				'label'     => __( 'Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'separator' => 'after',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .news-section .title-box.text-center .sec-sub-title' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .news-section .title-box.text-center .line-box .line-1' => 'background: {{VALUE}} !important',
					'{{WRAPPER}} .news-section .title-box.text-center .line-box .line-2' => 'background: {{VALUE}} !important',
					'{{WRAPPER}} .news-section .title-box.text-center .line-box .line-3' => 'background: {{VALUE}} !important',
				),
			
			)
		);

		$this->end_controls_section();

		// End of Section Sub Title 	==================	


		// Section Title 	==================

		$this->start_controls_section(
			'section_title_settings',
			array(
				'label' => __( 'Section Title Setting', 'dogri-elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);


		$this->add_control(
			'show_section_title',
			array(
				'label' => esc_html__( 'Show Section Title', 'dogri-elementore' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementor' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementor' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .news-section .title-box.text-center .sec-title' => 'display: {{VALUE}} !important',
				),
			)
		);

		$this->add_control(
			'section_title_alignment',
			array(
				'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'condition'    => array( 'show_section_title' => 'show' ),
				'toggle' => true,
				'selectors' => array(
				
					'{{WRAPPER}} .news-section .title-box.text-center' => 'text-align: {{VALUE}}',
				),
			)
		);			

		$this->add_control(
			'section_title_margin',
			array(
				'label'     => __( 'Magin', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
					'{{WRAPPER}} .news-section .title-box.text-center .sec-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);

		$this->add_control(
			'section_title_padding',
			array(
				'label'     => __( 'Padding', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
					'{{WRAPPER}} .news-section .title-box.text-center .sec-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'section_title_typography',
				'condition'    => array( 'show_section_title' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementor' ),
				'selector' => '{{WRAPPER}} .news-section .title-box.text-center .sec-title',
			)
		);

		$this->add_control(
			'section_title_color',
			array(
				'label'     => __( 'Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .news-section .title-box.text-center .sec-title' => 'color: {{VALUE}} !important',

				),
			)
		);

		$this->end_controls_section();					
		//End of Section Title 	==================

		//Text==========================
		$this->start_controls_section(
			'text_settings',
			array(
				'label' => __( 'Text Setting', 'dogri-elementore' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		); 
		
		$this->add_control(
			'show_text',
			array(
				'label' => esc_html__( 'Show Text', 'dogri-elementore' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementore' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementore' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .news-section .lower-content h3 a' => 'display: {{VALUE}} !important',
				),   
			)
		);
		
		$this->add_control(
			'text_alignment',
			array(
				'label' => esc_html__( 'Alignment', 'dogri-elementore' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementore' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementore' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementore' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'condition'    => array( 'show_text' => 'show' ),
				'toggle' => true,
				'selectors' => array(
					'{{WRAPPER}} .news-section .lower-content' => 'text-align: {{VALUE}}',
				), 
			)
		);
		
		$this->add_control(
			'text_margin',
			array(
				'label'     => __( 'Margin', 'dogri-elementore' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
				'condition'    => array( 'show_text' => 'show' ),
				'selectors' => array(
					'{{WRAPPER}} .news-section .lower-content h3 a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);
		
		$this->add_control(
			'text_padding',
			array(
				'label'     => __( 'Padding', 'dogri-elementore' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
				'condition'    => array( 'show_text' => 'show' ),
				'selectors' => array(
					'{{WRAPPER}} .news-section .lower-content h3 a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'text_typography',
				'condition'    => array( 'show_text' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementore' ),
				'selector' => '{{WRAPPER}} .news-section .lower-content h3 a',
			)
		); 
		
		$this->add_control(
			'text_color',
			array(
				'label'     => __( 'Color', 'dogri-elementore' ),
				'condition'    => array( 'show_text' => 'show' ),
				'separator' => 'after',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .news-section .lower-content h3 a' => 'color: {{VALUE}} !important',
				),
			)
		);

		$this->add_control(
			'text_hover_color',
			array(
				'label'     => __( 'Hover Color', 'dogri-elementore' ),
				'condition'    => array( 'show_text' => 'show' ),
				'separator' => 'after',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .news-section .lower-content h3 a:hover' => 'color: {{VALUE}} !important',
				),
			)
		);

		$this->end_controls_section();
		//End of Text=========	


	}

	public function render() {
		$settings  = $this->get_settings_for_display(); 
		extract($settings);

		$background_bg_src = wp_get_attachment_image_src( $settings['background_bg']['id'], 'full' );
		$bg_image_url = $background_bg_src ? $background_bg_src[0] : ''; 

	    $cat = get_term_by('slug', $cat, 'category');
	    if( !empty($cat->term_id) ){
	        $term_id = $cat->term_id;
	    }else{
	        $term_id = 1;
	    }

		if( $chose_style == 'blog-style-1' ): ?>


			<!-- Blog Section -->
			<section class="blog-section two sec-padding-s position-relative">
				<div class="shape-1" style="background-image: url(<?php echo esc_url( $bg_image_url ); ?>);"></div>
				<div class="dogri-container">
				<?php 
					if( $settings['show_heading_section'] == 'yes'): ?>
					<div class="title-box text-center">
						<?php 
						if (( '' !== $sub_title ) && ( $show_sub_title )) : ?>
							<h4 class="sec-sub-title"><?php print wp_kses_post( $sub_title ); ?></h4>

						<?php 
						endif; ?> 
					<?php 
						if (( '' !== $title ) && ( $show_title )) : ?>
						<h2 class="sec-title"><?php print wp_kses_post( $title ); ?></h2>
					<?php 
					endif; ?>
					</div>
					<?php
					endif; ?>
					<div class="row g-4">
						<!-- block -->
						<?php 
							$q = new \WP_Query(array(
								'post_type'     => 'post',
								'posts_per_page'=> $number,
								'cat'			=> $term_id,
								'orderby'       => 'menu_order '.$orderby,
								'order'         => $order,
								'tax_query' => array(
									array(
										'taxonomy' => 'post_format',
										'field'    => 'slug',
										'terms' => array( 
											'post-format-image', 
										),
										'operator' => 'IN',
									),
								),
							));

						if($q->have_posts()):
							while($q->have_posts()): $q->the_post(); 
							$featured_post_img = get_post_meta( get_the_ID(), 'featured_blog_image', true );
							?>	
						<div class="col-lg-4 col-md-6">
							<div class="blog-style-1 ">
								<?php
								if( $featured_post_img !== "" ): ?>
									<figure class="image">
										<a href="<?php the_permalink(); ?>"><img src="<?php echo esc_url($featured_post_img); ?>" alt="post-1" /></a>
									</figure>
								<?php
								else: ?>
									<figure class="image">
									<a href="<?php the_permalink(); ?>"><img src="<?php the_post_thumbnail_url('dogri-featured-post-full'); ?>" alt="post-1" /></a>
									</figure>
								<?php
								endif; ?>
								<div class="fig-content-area">
									<ul class="blog-info">
										<li><a href="<?php print esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><i class="fa-light fa-user"></i> <?php print get_the_author(); ?></a></li>
										<li><a href="#"><i class="fa-thin fa-comment-captions"></i> 0 comments</a></li>
									</ul>
									<h4><a href="<?php the_permalink(); ?>"><?php print wp_trim_words(get_the_title(), $heading_word_count, ''); ?></a></h4>    
								</div>
							</div>
						</div>
						<?php 
							endwhile; 
							wp_reset_postdata(); 
						endif; 
						?> 
					</div>
				</div>
			</section>
			<!-- Blog Section End -->

			<?php 
			elseif ($chose_style == 'blog-style-2') : ?>
			<!-- news-section -->
			<section class="news-section three sec-pad">
				<div class="auto-container">

					<?php 
					if( $settings['show_heading_section'] == 'yes'): ?>
					<div class="title-box text-centerd mb_60">
					<?php 
					if (( '' !== $sub_title ) && ( $show_sub_title )) : ?>
						<h5 class="sec-sub-title"><?php print wp_kses_post( $sub_title ); ?></h5>
						<div class="line-box">
							<span class="line-1"></span>
							<span class="line-2"></span>
							<span class="line-3"></span>
						</div>
					<?php 
					endif; ?> 
					<?php 
						if (( '' !== $title ) && ( $show_title )) : ?>
						<h2 class="sec-title"><?php print wp_kses_post( $title ); ?></h2>
					<?php 
					endif; ?>
					</div>
					<?php
					endif; ?>

						<div class="row g-4">
						<?php 
							$q = new \WP_Query(array(
								'post_type'     => 'post',
								'posts_per_page'=> $number,
								'cat'			=> $term_id,
								'orderby'       => 'menu_order '.$orderby,
								'order'         => $order,
								'tax_query' => array(
									array(
										'taxonomy' => 'post_format',
										'field'    => 'slug',
										'terms' => array( 
											'post-format-image', 
										),
										'operator' => 'IN',
									),
								),
							));

						if($q->have_posts()):
							while($q->have_posts()): $q->the_post(); 
							$featured_post_img = get_post_meta( get_the_ID(), 'featured_blog_image', true );
							?>						
							
								<div class="col-lg-4 col-md-6">
									<div class="news-block-one ">
										<div class="inner-box">
											<div class="image-box">

											<?php
											if( $featured_post_img !== "" ): ?>
												<figure class="image">
													<a href="<?php the_permalink(); ?>"><img src="<?php echo esc_url($featured_post_img); ?>" alt="post-1" /></a>
												</figure>
											<?php
											else: ?>
												<figure class="image">
												<a href="<?php the_permalink(); ?>"><img src="<?php the_post_thumbnail_url('transco-featured-post-full'); ?>" alt="post-1" /></a>
												</figure>
											<?php
											endif; ?>
												<div class="post-info">
													<h5 class="date"><a href="#"><?php the_time('M j, Y'); ?></a></h5>
													<h5 class="admin"><a href="<?php print esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><?php print get_the_author(); ?></a></h5>
												</div>
											</div>
											<div class="lower-content text-centerd">
												<h3><a href="<?php the_permalink(); ?>"><?php print wp_trim_words(get_the_title(), $heading_word_count, ''); ?></a></h3>
												<div class="link">
													<a href="<?php the_permalink(); ?>" class="news-btn-1">Read More</a>
													<a href="<?php the_permalink(); ?>" class="news-btn-2"><i class="flaticon-right-arrow-2"></i></a>
												</div>	
											</div>
										</div>							
									</div>	
								</div>							
							<?php 
								endwhile; 
								wp_reset_postdata(); 
							endif; 
							?> 	
						</div>	
					</div>
				</section>
			<?php 
			endif; ?>

	<?php
	}
}